<?php

# -------------------------------------------------------------------
# MAIL WEB PAGE TO A FRIEND
# Sends the current web page via email and returns to the current 
# page.

# -------------------------------------------------------------------
# SET REQUEST PARAMETER VARIABLES 
#
# request parameter names
$yourEmailParam 	= "youremail";
$friendEmailParam	= "friendemail";
$urlParam			= "url";

# default request parameter values
$defYourEmail		= "Your email";
$defFriendEmail		= "Your friend`s email";

# -------------------------------------------------------------------
# SET SMTP VARIABLES 
#
$SMTP_Host = "localhost";

#subject
$defSubject = "Something interesting from TUBMac";
 

if (array_key_exists($yourEmailParam, $_GET) and array_key_exists($friendEmailParam, $_GET)) {
	$yourEmail = $_GET[$yourEmailParam];
	$friendEmail = $_GET[$friendEmailParam];
	$url = $_GET[$urlParam];
	if ($yourEmail != $defYourEmail and $friendEmail != $defFriendEmail) {
		sendToFriend($SMTP_Host, $yourEmail, $friendEmail, $defSubject, $url);
	}
} 

header("Location: $url");
exit;


# -------------------------------------------------------------------
# SEND FUNCTION
#
# @param String $from 		: sender's email address
# @param String $to			: addressee's email
# @param String $subject	: subject matter
# @param String $url		: url of web page to send
#
function sendToFriend($host, $from, $to, $subject, $url) {
	

	$handle = fopen($url, "r");	
	$contents = "";
	do {
   		$data = fread($handle, 8192);
    	if (strlen($data) == 0) {
        	break;
    	}
    	$contents .= $data;
	} while(true);
	//$read = fread($open, 200000);
	fclose($handle);


	$smail = new SMTP($host); //Initiate class into object. 

	if ($smail->errno)
		die ($smail->errmsg()); 

	if (!$smail->SetFrom($from))
		die ($smail->errmsg()); 

	if (!$smail->SetToTitle($to))
		die ($smail->errmsg()); 

	if (!$smail->SetTo($to))
		die ($smail->errmsg()); 
		
	if (!$smail->SetReplyTo($from))
		die ($smail->errmsg()); 

	if (!$smail->SetCC(''))
		die ($smail->errmsg()); 

	if (!$smail->SetSubject($subject))
		die ($smail->errmsg()); 

	if (!$smail->SetText($contents))
		die ($smail->errmsg()); 

	if (!$smail->sendmail())
		die ($smail->errmsg()); 

	if (!$smail->end())
		die ($smail->errmsg()); 

#	echo "Successful"; 
}


# -------------------------------------------------------------------
# SMTP CLASS
# Handles the communication with the mail server.
#
Class SMTP {
 
// global varibles

Var	$errno	   = 0; 
Var	$errmsg	   = ''; 
Var	$errors=Array(
	1 => 'Invalid Input',
	2 => 'Unable to establish connection', 
	3 => 'Connection timed out', 
	4 => 'SMTP Error returned', 
	); 

Var $server		= "";
Var $user		= "";
Var	$sock		= false; 
Var	$readlength	= 1024; 

Var	$mailto		 = array(); 
Var	$mailcc		 = array(); 
Var $mailfrom       = "";
Var $mailfromtitle  = '';
Var	$mailreplyto    = "";
Var $mailsubject    = "";
Var $mailtext       = "";
Var	$attachments	= array(); 

Var $deadmsg        = "";
Var $verbose        = "0";
                            //Modify this for verbose output of the transaction..
                            //1 for verbose
                            //0 for silent
 
Function SMTP($server, $timeout=10)
	{ 
	// Return false if we can't get an SMTP connection... 

	if (strlen($server)<=0) 
		return $this->error(1, 'server'); 
	else 	$this->server=$server; 

	if (!$this->sock = fsockopen($server, 25, &$errno, &$errstr, $timeout)) 
		return $this->error(2); 

	if (!socket_set_blocking($this->sock, true)) 
		return $this->error(4, 'set blocking'); 

	if (!$this->GetFeedback()) 
		return $this->error(2, 'during onset'); 

	return true; 
	} 

Function Error($errno, $message)
	{ 
	$this->errno=$errno; 
	$this->errmsg.=$message; 
	return false; 
	} 

Function ErrMsg($error=false)
	{ 
	if (false===$error) 
		{ 
		$errno=$this->errno; 
		return $this->$errors[$errno].' '.$this->errmsg; 
		} 
	else 	return $this->$errors[$error]; 
	} 

Function ErrNo()
	{ 
	return $this->errno; 
	} 

Function SetSubject($subject)
	{ 
	if (strlen($subject)<=0) 
		return $this->Error(1, 'subject'); 
        $this->mailsubject = ereg_replace("\n"," ",$subject);
	return true; 
	} 

Function setText($text)
	{
	if (strlen($text)<=0) 
		return $this->Error(1, 'message body'); 
        $text = ereg_replace("\n.\n", "\n. \n", $text); 
        $text = ereg_replace("\n.\r", "\n. \r", $text); 
        $this->mailtext = $text;
	return true; 
	}

Function SetTo($to)
	{ 
	// THIS CAN BE USED TO SET AS MANY "BCC" RECIPIENTS AS YOU LIKE. 
	
	if (strlen($to)<=0) 
		return $this->Error(1, '"to" too short'); 
	if (strlen($to)>=129)
		return $this->Error(1, '"to" too long'); 
	$this->mailto[]=$to; 
	return true; 
	} 

Function SetReplyTo($to)
	{ 
	if (strlen($to)<=0) 
		return $this->Error(1, '"replyto" too short'); 
	if (strlen($to)>=129)
		return $this->Error(1, '"replyto" too long'); 
	$this->mailreplyto=$to; 
	return true; 
	} 


Function SetToTitle($title)
	{ 
	if (strlen($title)<=0) 
		return $this->Error(1, 'totitle too short'); 
	if (strlen($title)>=128) 
		return $this->Error(1, 'totitle too long'); 
	$this->mailtotitle="<$title>"; 
	return true; 
	} 

function SetCC($to)
	{
	// THIS WORKS LIKE "SETTO" ABOVE, BUT TELLS EVERYBODY WHO'S INVOLVED. 
	// This is a potential privacy issue...

	if (strlen($to)>0) {
		if (!$this->setto($to)) 
			return false; 
		$this->mailcc[]=$to;
	}
	return true; 
	}

Function SetFrom($from)
	{ 
	if (strlen($from)<=0) 
		return $this->Error(1, 'from too short'); 
	if (strlen($from)>=128) 
		return $this->Error(1, 'from too long'); 
	$this->mailfrom=$from; 
	return true; 
	} 

Function SetFromTitle($title)
	{ 
	if (strlen($title)<=0) 
		return $this->Error(1, 'fromtitle too short'); 
	if (strlen($title)>=128) 
		return $this->Error(1, 'fromtitle too long'); 
	$this->mailfromtitle=$title; 
	return true; 
	} 

function AddAttachment($type, $data, $name) 
	{ 
	// THIS WILL TAKE ATTACHMENTS, BUT WON'T YET MAIL THEM. 
	$insert=sizeof($this->attachements); 
	$this->attachements[$insert][data]=$data; 
	$this->attachements[$insert][type]=$type; 
	$this->attachements[$insert][name]=$name; 
	return false; 
	} 

Function BuildBody($MIMEType)
	{ 
	// Take the text, add any attachements, doc type, etc. 
	// attachments currently don't work. 

	// SET MIME TYPE
	if ($MIMEType=='text') 
		$return.="Content-Type: text/plain; charset=iso-8859-1\r\n";
	elseif($MIMEType=='html')
		$return.="Content-Type: text/html; charset=iso-8859-1\r\n"; 
	else
		$return.="Content-Type: text/plain; charset=iso-8859-1\r\n"; 

	// SET TO HEADER
	if (strlen($this->mailtotitle)>=1) 
		$return.="To: ".$this->mailtotitle."\r\n"; 		
		
	// SET REPLY-TO HEADER
	if (strlen($this->mailreplyto)>=1)
		$return.="Reply-To: ".$this->mailreplyto."\r\n";

	// SET FROM HEADER
	if (strlen($this->fromtitle)>=1) 
		$return.="From: ".$this->mailfromtitle." <".$this->mailFrom.">\r\n"; 
	else	$return.="From: ".$this->mailfrom."\r\n"; 

	if (sizeof($this->mailcc)>=1) 
		{
		$return.="Cc:"; 
		for ($i=0; $i<sizeof($this->mailcc); $i++) 
			{ 
			if ($i)
				$return.=", "; 
			$return.=$this->mailcc[$i]; 
			} 
		$return.="\r\n"; 
		} 

	if (strlen($this->mailsubject)>=1) 
		$return.="Subject: ".$this->mailsubject."\r\n"; 

	$return .="X-Priority: 1\r\n"; 
	$return .= $this->mailtext; 

	return $return; 
	} 

Function sendmail($text_type='html')
	{
        if (!$this->sock) 
		return $this->error(2); 
	else 	{
		if (!$body=$this->BuildBody($text_type)) 
			return $this->Error(1, 'BuildBody Failed'); 

		$head[]="HELO ".$this->server;
		$head[]="MAIL FROM:<".$this->mailfrom.">";
		while (list($key, $value)= each($this->mailto)) 
			{ 
			$head[]="RCPT TO:<$value>";
			} 
		$head[]='DATA'; 

		reset ($head); 

		while (list($key, $value)=each ($head)) 
			{ 
			fputs($this->sock, $value."\r\n"); 
			if (!$this->GetFeedback())
				return $this->error($this->errno(), "($value)"); 
			} 
		fputs($this->sock, "$body\r\n.\r\n"); 
		if (!$this->GetFeedback())
			return false; 
                }
	$this->ResetData(); 
	return true; 
	}

function ResetData()
	{ 
	$mailto		= array(); 
	$mailfrom       = "";
	$mailfromtitle  = '';
	$mailreplyto    = "";
	$mailsubject    = "";
	$mailtext       = "";
	$attachments	= array(); 
	return true; 
	} 


Function GetFeedback()
	{ 
	if (!$response=fgets($this->sock, $this->readlength)) 
		return false; 
	if ($this->IsOK($response)) 
		return true; 
	else 	return false; 
	} 

Function IsOK ($input) 
	{ 
	// Extract the return code from the SMTP server, and make sure it's a 
	// 'yahoo' instead of a 'shucks'. 

	if (!ereg("((^[0-9])([0-9]*))", $input, $regs)) 
		return $this->error(1, 'input'); 

	$code=$regs[1]; 

	switch ($code) 
		{
		case '220':
		case '221':
		case '250':
		case '251': 
		case '354':
			return true; 
			break; 
		default:
			return $this->error(4, $input); 
			break; 
		} 
	} 

Function end()
	{
	if (!$this->sock) 
		return $this->error(3, 'function end'); 

	fputs($this->sock, "QUIT\r\n"); 

	if ($this->GetFeedback()) 
		{ 
		fclose($this->sock);
		return true; 
		} 
	else 	{ 
		return false; 
		} 
	}

} // END OF SMTP CLASS... 


?>
