<?php

# -------------------------------------------------------------------
# FILE EXISTENCE CHECKING AND PREP
# In which we establish a URL to this document, and
# initialize some variables, etc. 

$whoami =  'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
$dirName = 'http://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['SCRIPT_NAME'])."/";
$datadirLen = strlen($datadir);
$filteredPaths = array();
$lastDoY = null;

# -------------------------------------------------------------------
# URL-BASED FILTERS...

if (array_key_exists("category", $_GET)) {
	$categoryFilter = $_GET["category"];
} else {
	$categoryFilter = null;
}

if (array_key_exists("entry", $_GET)) {
	$entryFilter = $_GET["entry"];
}  else {
	$entryFilter = null;
}

if (array_key_exists("date", $_GET)) {
	$dateFilter = $_GET["date"];
	$dateFilterType = checkDateFilter($dateFilter);
	
	if ($dateFilterType == 0) {
		$dateFilter = null;
	}
} else {
	$dateFilter = null;
}

if (array_key_exists("start", $_GET)) {
	$startingEntry = $_GET["start"];
} else {
	$startingEntry = 0;
}

if (array_key_exists("phrase", $_GET)) {
	$searchPhrase = $_GET["phrase"];
} else {
	$searchPhrase = "";
}


# -------------------------------------------------------------------
# FIND VIABLE DIRECTORIES.

$stopCheck = 0;
if (chdir($datadir) !== true) {
	$theError = explainError("datadir");
	echo "$theError";
	exit;
} else {
	$checkDirs[0] = $datadir;
	$sansdatadir = strlen($datadir) + 1;
	
	# Here we can skip subfolder freakout altogether if $depth == 1
	if ($depth !== 1) {
		$startHere = 0;
		$foundAndDoneSoFar = 1;
		while ($foundAndDoneSoFar > 0 and $stopCheck != 1) {
			$theOne = $checkDirs[$startHere];
			if ($depth !== 0) {
				$justThePath = substr($theOne, $sansdatadir);
				$level = substr_count($justThePath, "/") + 1;
				if ($level == $depth) {
					array_splice($checkDirs, $startHere, 1);
					$stopCheck = 1;
				}
			}
			$howManyHere = findFolders($theOne);
			$foundAndDoneSoFar += $howManyHere;
			$foundAndDoneSoFar -= 1;
			$startHere += 1;
		}
	}

# BEFORE AMASSING OUR .TXT FILES, FILTER BY PATHS/CATEGORIES

	if ($categoryFilter != null) {
		$numofPathsNow = count($checkDirs);
		for ($ck = 0; $ck < $numofPathsNow; $ck++) {
			if (strpos($checkDirs[$ck], $categoryFilter) == true) {
				$filteredPaths[] = $checkDirs[$ck];
			}
		}
	}
	if ($categoryFilter == null) {
		$filteredPaths = array_merge($checkDirs, $filteredPaths);
	}

# CHECK OUR ARRAY OF VIABLE DIRECTORIES FOR .TXT FILES.

	$numofChecks = count($filteredPaths);
	for ($tx = 0; $tx < $numofChecks; $tx++) {
		$diri = null;
		$file = null;
		$diri = opendir($filteredPaths[$tx]);
		while (($file = readdir($diri)) !== false) {
			if (ereg('\.txt$', $file) != false) {
				$thisPath = $filteredPaths[$tx]."/".$file;
				$theseFiles[] = $thisPath;
			}
		}
		closedir($diri);
	}
}

if (count($theseFiles) == 0) {
		$theError = explainError("categories");
		echo "$theError";
		exit;
}

# -------------------------------------------------------------------
# FIRST FILE LOOP. PROCESS .TXT FILE CONTENTS

$numtoProcess = count($theseFiles);
for ($ty = 0; $ty < $numtoProcess; $ty++) {
	$content = file($theseFiles[$ty]);
	$thisModDate = filemtime($theseFiles[$ty]);
	$thisTitle = rtrim($content[0]);
	$numofLines = count($content);
	
	$thisTextArray = null;
	for ($m = 2; $m < $numofLines; $m++) {
		$thisTextArray[] = $content[$m];
		$numofTextLines = count($thisTextArray);
		$thisText = null;
		for ($n = 0; $n < $numofTextLines; $n++) {
			$thisText = $thisText.$thisTextArray[$n];
		}
	}
	
	if ($flavFilter == 'rss' or $flavFilter == 'RSS') {
		$thisText = eregi_replace ("../Images/", "Images/", $thisText);
		$pathToDocImages = $dirName;
		
		# Start of Hacks -
		$thisText = eregi_replace ("\.\.\/\.\.\/", 'http://'.$_SERVER['HTTP_HOST'].'/', $thisText);
		$thisText = eregi_replace ("\.\.\/", $pathToDocImages, $thisText);
		# End of Hacks -
		}
	else $pathToDocImages = "../";
		
	$thisText = eregi_replace ("<img src=\"Images/", "<img src=\"" . $pathToDocImages . "Images/", $thisText);
	
	if ($searchPhrase != "" and strpos(strtolower($thisText), strtolower ($searchPhrase)) === false) continue;
	
	$usedates[] = $thisModDate;
	$titles[] = $thisTitle;
	$texts[] = $thisText;
	$files[] = $theseFiles[$ty];
}

# -------------------------------------------------------------------
# NOW COMES THE REVERSE CHRONOLOGICAL SORTING

if (count($usedates) > 0) array_multisort($usedates, SORT_DESC, $titles, $texts, $files);
$entries = count($usedates);

# -------------------------------------------------------------------
# DETERMINE WHERE TO START AND STOP IN THE UPCOMING STORY ARRAYS

$readMoreAnchor = ""; 

if ($num_entries < $entries and $flavFilter !== "archive" and !$categoryFilter) {
	$thisManyEntries = $startingEntry + $num_entries;
	if ($thisManyEntries >= $entries) {
			$thisManyEntries = $entries;
	}
	else {
			if ($searchPhrase != "")
			{	
				$readMoreAnchor = "<a href=\"".$whoami."?phrase=".$searchPhrase."&start=".$thisManyEntries."&category=$categoryFilter"."\">Read more ...</a></p>";
			}
			else {
				$readMoreAnchor = "<a href=\"".$whoami."?start=".$thisManyEntries."&category=$categoryFilter"."\">Read more ...</a></p>";	
			}
	}
} else {
	$thisManyEntries = $entries;
}

if ($flavFilter == 'rss' or $flavFilter == 'RSS') {
	$readMoreAnchor = "";
	$startingEntry = 0;
	$thisManyEntries = $num_entries;
	if ($thisManyEntries >= $entries) $thisManyEntries = $entries;
}

if ($dateFilter or $entryFilter) {
	$readMoreAnchor = "";
	$startingEntry = 0;
	$thisManyEntries = $entries;
}

# -------------------------------------------------------------------
# SECOND FILE LOOP
# In which we format the actual entries and do more filtering.

for ($h = $startingEntry; $h < $thisManyEntries; $h++) {
	# ON EACH PASS, WE FIRST MAKE SURE OUR DATE MATCHES ANY USER-SUPPLIED
	# DATE-FILTER FROM THE URL. 

	$excludeMeD = 0;

	if ($dateFilter) {
		$YYYY = date("Y",$usedates[$h]);
		$YYYYMM = date("Ym",$usedates[$h]);
		$YYYYMMDD = date("Ymd",$usedates[$h]);
		switch ($dateFilterType) {
			case '4':
			if ($dateFilter !== $YYYY) $excludeMeD = 1;
			break;				
			case '6':
			if ($dateFilter !== $YYYYMM) $excludeMeD = 1;
			break;				
			case '8':
			if ($dateFilter !== $YYYYMMDD) $excludeMeD = 1;
			break;				
		}
	}

	# WE ALSO FILTER BY ENTRYFILTER.

	$excludeMeE = 0;
	$displayfilepath = substr_replace($files[$h], '', 0, $datadirLen);
	
	if ($entryFilter) {
		if ($entryFilter !== $displayfilepath) $excludeMeE = 1;
	}

	# FIRST BUILD THE TEXT OF THE ENTRY, THEN ITS METADATA.

	if ($flavFilter == 'rss') {
		$texts[$h] = ereg_replace("\n\n", "\n", $texts[$h]);
	}

	$theText[$h] = ereg_replace("\n", "</p><p class=\"blog\">", $texts[$h]);
	$theText[$h] = "<p class=\"blog\">".$theText[$h];
	
	$displaytime = date("g:iA T",$usedates[$h]);
	$displaydate = date("D d M Y",$usedates[$h]);
	$thisDoY = date("Ymd", $usedates[$h]);
	$diffDoY = $thisDoY - $lastDoY;

	# if not excluded by date or entry filter, we continue with this entry...
	
	if (!$excludeMeD and !$excludeMeE) {

		# DETERMINE IF WE REQUIRE A DAY DIVIDER.
		# We don't use one if this is an RSS file.

		if ($flavFilter !== 'RSS' and $flavFilter !== 'rss') {
		
			if ($lastDoY == '' or $diffDoY < 0 or $entryFilter) {
			
		        # MAKE THE DIVIDER LINKABLE IF THIS IS AN ARCHIVE
				if ($flavFilter == 'archive') {
					$archiveDate = date("Ymd", $usedates[$h]);
					$storyArray[] = "\n<p><a class=\"blogdate\" href=\"".$whoami."?date=".$archiveDate."\">".$displaydate."</a>\n";
				} else {
					$storyArray[] = "\n<p class=\"blogdate\">" . $displaydate;
				}
				$storyArray[] = "</p>\n";
			
			} else {
			$storyArray[] = "\n<!-- $displaydate -->\n";
			}
			
		}

		# NEXT, WE BREAK DOWN THE PATH TO THE FILE FOR USE AS CATEGORY LINKS

		$sanscat = strrchr($displayfilepath, '/');
		$dacat = ereg_replace($sanscat, '', $displayfilepath);
		if ($dacat) {
			$displaycat = ltrim($dacat, '/');
		} else {
			$displaycat = null;
		}

		# FORMAT THE ACTUAL ENTRY WITH GENERIC VERSIONS OR VIA A FLAVOR FILE,

		if (!$flavFilter) {
			$storyArray[] = htmlStory($titles[$h], $theText[$h], $displaytime, $displayfilepath, $displaycat);
		} else if ($flavFilter == 'rss' or $flavFilter == 'RSS') {
			$storyArray[] = rssStory(htmlspecialchars($titles[$h]), htmlspecialchars($theText[$h]), htmlspecialchars($displayfilepath));
		} else if ($flavFilter == 'archive') {
			$storyArray[] = htmlStory($titles[$h], $theText[$h], $displaytime, $displayfilepath, $displaycat);
		} 
	}
	$lastDoY = $thisDoY;
}

# DECIDE IF WE NEED A READ-MORE ANCHOR

if ($readMoreAnchor != "") $storyArray[] = $readMoreAnchor;


# END SECOND FILE LOOP
# -------------------------------------------------------------------

# DETERMINE THE DOCUMENT TYPE AND SEND INITIAL HEADER()

if ($flavFilter == 'rss' or $flavFilter == 'RSS') {
	header('Content-type: text/xml');
	echo rssHead($blog_title, $blog_description, $blog_language);
}

if ($flavFilter == "archive" or $categoryFilter or $entryFilter) {
		echo "<div align=\"right\"><p class=\"commentary\"><a href=\"http://www.geekculture.com/joyoftech/index.html\"><img height=\"82\" width=\"79\" src=\"http://www.geekculture.com/joyoftech/joyimages/jottodaythumb.gif\" align=\"top\" border=\"0\" alt=\"Latest Joy of Tech!\"></a><b> ... Introducing the latest Joy of Tech</b> ... from Geek Culture</p></div><p>";
		echo "<h2>$blog_description - Archives</h2>";
		
		echo "<p class=\"blogcategory\"> List of Categories : ";		
		$numofPathsNow = count($checkDirs);
		for ($ck = 1; $ck < $numofPathsNow; $ck++) {
			$catname = strrchr($checkDirs[$ck], '/');
			$catname = ltrim($catname, '/');
			echo " <a class=\"blogcatanchor\" href=\"".$whoami."?category=".$catname."\">".$catname."</a> * ";
		}		
		echo "</p>\n";
}

if ($categoryFilter) echo "<h3>Category: ".$categoryFilter."</h3>";

# ECHO THE STORY ARRAY TO THE BROWSER

if (count($storyArray) == 0) {
	$theError = explainError("noentries");
	echo "$theError";
} else {
	foreach ($storyArray as $storyVal) {
	echo $storyVal;
	}
}

# ECHO THE FOOTER BLOCK TO THE BROWSER

if ($flavFilter == "rss") echo rssFoot();


# THE END
# -------------------------------------------------------------------

# HTML FUNCTIONS

function htmlStory($title,$text,$time,$path,$cat) {
	global $whoami;
	global $flavFilter;
	global $categoryFilter;
	
	$story = array();
	$storyThang = null;
	
	if ($flavFilter == "archive" or $categoryFilter) {
		$story[] = "<p><a  class=\"heading\" href=\"$whoami?entry=$path\">$title</a></p>\n";
	} else {
		$story[] = "<h3>".$title."</h3>\n";
		$story[] = "<p class=\"blogcategory\"> Category : " . "<a class=\"blogcatanchor\" href=\"".$whoami."?category=".$cat."\">".$cat."</a>" . "</p>\n";
		$story[] = "<p class=\"blog\">".$text."</p>\n";
		$story[] = "<p class=\"blogmeta\"> Posted ";
		$story[] = "at ".$time." | ";
		$story[] = "<a href=\"".$whoami."?entry=".$path."\">permalink</a></p>";
	}
		
	foreach ($story as $storyVal) {
		$storyThang = $storyThang.$storyVal;
	}
	return $storyThang;
}

# RSS FUNCTIONS

function rssHead($thetitle, $description, $lang) {
	global $makeetag;
	global $whoami;
	$head = array();
	$headThang = null;
	$head[] = '<?xml version="1.0"?'.'>'."\n";
	$head[] = '<!-- name="generator" content="phposxom/0.6b" -->'."\n";
	$head[] = '<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN" ';
	$head[] = '"http://my.netscape.com/publish/formats/rss-0.91.dtd">';
	$head[] = "<rss version=\"0.91\">\n";
	$head[] = "<channel>\n";
	$head[] = "<title>".$thetitle."</title>\n";
	$head[] = "<link>".$whoami."</link>\n";
	$head[] = "<description>".$description."</description>\n";
	$head[] = "<language>".$lang."</language>\n";
	foreach ($head as $headVal) {
		$headThang = $headThang.$headVal;
	}
	return $headThang;
}

function rssStory($title,$text,$path) {
	global $whoami;
	$story = array();
	$storyThang = null;
	$linkstart = htmlspecialchars($whoami);
	$story[] = "<item>\n";
	$story[] = "<title>".$title."</title>\n";
	$story[] = "<link>".$linkstart."?entry=".$path."</link>\n";
	$story[] = "<description>".$text."</description>\n";
	$story[] = "</item>\n";
	foreach ($story as $storyVal) {
		$storyThang = $storyThang.$storyVal;
	}
	return $storyThang;
}

function rssFoot() {
	return "</channel>\n</rss>\n";
}

# -------------------------------------------------------------------
# OTHER FUNCTIONS

function findFolders($startPath) {
	global $checkDirs;
	global $startHere;
	global $datadir;
	$didThisMany = 0;
	chdir($startPath);
	$dirh = opendir($startPath);
	while (($file = readdir($dirh)) !== false) {
		if (is_dir($file) == true) {
			if ($file != '.' and $file != '..') {
				$goodDir = $startPath."/".$file;
				$checkDirs[] = $goodDir;
				$didThisMany += 1;
			}
		}
	}
	closedir($dirh);
	chdir($datadir);
	return $didThisMany;
}

function checkDateFilter($filter) {
	$dateFilterType = 0;
	$dateFilterLen = strlen($filter);
	
	if ($dateFilterLen == 4 or $dateFilterLen == 6 or $dateFilterLen == 8) {
		$dateFilterType = $dateFilterLen;
	} else if ($dateFilterLen < 4) {
		$theError = explainError("shortdate");
		echo "$theError";
	} else if ($dateFilterLen > 8) {
		$theError = explainError("longdate");
		echo "$theError";
	} else if ($dateFilterLen == 5 or $dateFilterLen == 7 or is_numeric($dateFilter) == false) {
		$theError = explainError("wrongdate");
		echo "$theError";
	}
	
	return $dateFilterType;
}

function explainError($x) {
	if ($x == "datadir") {
		return "<p>Whoops, can't find the Docs folder.</p>\n";
	} else if ($x == "categories") {
		return "<p>There are no .txt files to process. This could happen if you have no .txt files at all in your Docs folder, or there are no .txt files for the category chosen, or you're searching for a category that sits in a folder lower than the depth you have set.</p>\n";
	} else if ($x == "shortdate") {
		return "<p>The date you entered as a filter seems to be too short to work.</p>\n";
	} else if ($x == "longdate") {
		return "<p>The date you entered as a filter is too long to work.</p>\n";
	} else if ($x == "wrongdate") {
		return "<p>Something is screwy with the date you entered. It has the wrong number of digits.</p>\n";
	} else if ($x == "noentries") {
		return "<p>No Results. The combination of filters for this page has resulted in no entries. Try another combination of dates, categories or search phrase.</p>\n";
	}
}

?>