// https://codepen.io/chrisdavidmills/full/gzYjag/

var commandsArray = [
    {   "key": "Background Color",
        "cmd": "backColor",
        "val": "red",
        "desc": "Changes the document background color. In styleWithCss mode, it affects the background color of the containing block instead. This requires a color value string to be passed in as a value argument. (Internet Explorer uses this to set text background color.)"
    },
    {   "key": "Bold",
        "cmd": "bold",
        "icon": "bold",
        "desc": "Toggles bold on/off for the selection or at the insertion point. (Internet Explorer uses the STRONG tag instead of B.)"
    },
    {   "key": "Set Content Read Only",
        "cmd": "contentReadOnly",
        "desc": "Makes the content document either read-only or editable. This requires a boolean true/false to be passed in as a value argument. (Not supported by Internet Explorer.)"
    },
    {   "key": "Copy",
        "cmd": "copy",
        "icon": "clipboard",
        "desc": "Copies the current selection to the clipboard. Clipboard capability must be enabled in the user.js preference file. See"
    },
    {   "key": "Create Link",
        "cmd": "createLink",
        "val": "http://apple.com",
        "icon": "link",
        "desc": "Creates an anchor link from the selection, only if there is a selection. This requires the HREF URI string to be passed in as a value argument. The URI must contain at least a single character, which may be a white space. (Internet Explorer will create a link with a null URI value.)"
    },
    {   "key": "Cut",
        "cmd": "cut",
        "icon": "scissors",
        "desc": "Cuts the current selection and copies it to the clipboard. Clipboard capability must be enabled in the user.js preference file. See"
    },
    {   "key": "Decrease Font Size",
        "cmd": "decreaseFontSize",
        "desc": "Adds a SMALL tag around the selection or at the insertion point. (Not supported by Internet Explorer.)"
    },
    {   "key": "Default Paragraph Separator",
        "cmd": "defaultParagraphSeparator",
        "desc": "Changes the paragraph separator used when new paragraphs are created in editable text regions. See Differences in markup generation (https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Editable_content#Differences_in_markup_generation) for more details"
    },
    {   "key": "Delete",
        "cmd": "delete",
        "icon": "scissors",
        "desc": "Deletes the current selection."
    },
    {   "key": "Enable Absolute Position Editor",
        "cmd": "enableAbsolutePositionEditor",
        "desc": "Enables or disables the grabber that allows absolutely-positioned elements to be moved around. This is disabled by default in Firefox 63 Beta/Dev Edition."
    },
    {   "key": "Enable Inline Table Editing",
        "cmd": "enableInlineTableEditing",
        "desc": "Enables or disables the table row and column insertion and deletion controls. (Not supported by Internet Explorer.)"
    },
    {   "key": "Enable Object Resizing",
        "cmd": "enableObjectResizing",
        "desc": "Enables or disables the resize handles on images and other resizable objects. (Not supported by Internet Explorer.)"
    },
    {   "key": "Font Name",
        "cmd": "fontName",
        "val": "'Arial', monospace",
        "desc": "Changes the font name for the selection or at the insertion point. This requires a font name string (\"Arial\" for example) to be passed in as a value argument."
    },
    {   "key": "Font Size",
        "cmd": "fontSize",
        "val": "1-7",
        "icon": "text-height",
        "desc": "Changes the font size for the selection or at the insertion point. This requires an HTML font size (1-7) to be passed in as a value argument."
    },
    {   "key": "Fore Color",
        "cmd": "foreColor",
        "val": "rgba(0,0,0,.5)",
        "desc": "Changes a font color for the selection or at the insertion point. This requires a color value string to be passed in as a value argument."
    },
    {   "key": "Format Block",
        "cmd": "formatBlock",
        "val": "<blockquote>",
        "desc": "Adds an HTML block-style tag around the line containing the current selection, replacing the block element containing the line if one exists (in Firefox, BLOCKQUOTE is the exception - it will wrap any containing block element). Requires a tag-name string to be passed in as a value argument. Virtually all block style tags can be used (eg. \"H1\", \"P\", \"DL\", \"BLOCKQUOTE\"). (Internet Explorer supports only heading tags H1 - H6, ADDRESS, and PRE, which must also include the tag delimiters &lt; &gt;, such as \"&lt;H1&gt;\".)"
    },
    {   "key": "Forward Delete",
        "cmd": "forwardDelete",
        "desc": "Deletes the character ahead of the cursor's position.  It is the same as hitting the delete key."
    },
    {   "key": "Heading",
        "cmd": "heading",
        "val": "h3",
        "icon": "header",
        "desc": "Adds a heading tag around a selection or insertion point line. Requires the tag-name string to be passed in as a value argument (i.e. \"H1\", \"H6\"). (Not supported by Internet Explorer and Safari.)"
    },
    {   "key": "Hilite Color",
        "cmd": "hiliteColor",
        "val": "Orange",
        "desc": "Changes the background color for the selection or at the insertion point. Requires a color value string to be passed in as a value argument. UseCSS must be turned on for this to function. (Not supported by Internet Explorer.)"
    },
    {   "key": "Increase Font Size",
        "cmd": "increaseFontSize",
        "desc": "Adds a BIG tag around the selection or at the insertion point. (Not supported by Internet Explorer.)"
    },
    {   "key": "Indent",
        "cmd": "indent",
        "icon": "indent",
        "desc": "Indents the line containing the selection or insertion point. In Firefox, if the selection spans multiple lines at different levels of indentation, only the least indented lines in the selection will be indented."
    },
    {   "key": "Insert Br On Return",
        "cmd": "insertBrOnReturn",
        "desc": "Controls whether the Enter key inserts a br tag or splits the current block element into two. (Not supported by Internet Explorer.)"
    },
    {   "key": "Insert Horizontal Rule",
        "cmd": "insertHorizontalRule",
        "desc": "Inserts a horizontal rule at the insertion point (deletes selection)."
    },
    {   "key": "Insert HTML",
        "cmd": "insertHTML",
        "val": "&lt;h3&gt;Life is great!&lt;/h3&gt;",
        "icon": "code",
        "desc": "Inserts an HTML string at the insertion point (deletes selection). Requires a valid HTML string to be passed in as a value argument. (Not supported by Internet Explorer.)"
    },
    {   "key": "Insert Image",
        "cmd": "insertImage",
        "val": "http://dummyimage.com/160x90",
        "icon": "picture-o",
        "desc": "Inserts an image at the insertion point (deletes selection). Requires the image SRC URI string to be passed in as a value argument. The URI must contain at least a single character, which may be a white space. (Internet Explorer will create a link with a null URI value.)"
    },
    {   "key": "Insert Ordered List",
        "cmd": "insertOrderedList",
        "icon": "list-ol",
        "desc": "Creates a numbered ordered list for the selection or at the insertion point."
    },
    {   "key": "Insert Unordered List",
        "cmd": "insertUnorderedList",
        "icon": "list-ul",
        "desc": "Creates a bulleted unordered list for the selection or at the insertion point."
    },
    {   "key": "Insert Paragraph",
        "cmd": "insertParagraph",
        "icon": "paragraph",
        "desc": "Inserts a paragraph around the selection or the current line. (Internet Explorer inserts a paragraph at the insertion point and deletes the selection.)"
    },
    {   "key": "Insert Text",
        "cmd": "insertText",
        "val": "",
        "icon": "file-text-o",
        "desc": "Inserts the given plain text at the insertion point (deletes selection)."
    },
    {   "key": "Italic",
        "cmd": "italic",
        "icon": "italic",
        "desc": "Toggles italics on/off for the selection or at the insertion point. (Internet Explorer uses the EM tag instead of I.)"
    },
    {   "key": "Justify Center",
        "cmd": "justifyCenter",
        "icon": "align-center",
        "desc": "Centers the selection or insertion point."
    },
    {   "key": "Justify Full",
        "cmd": "justifyFull",
        "icon": "align-justify",
        "desc": "Justifies the selection or insertion point."
    },
    {   "key": "Justify Left",
        "cmd": "justifyLeft",
        "icon": "align-left",
        "desc": "Justifies the selection or insertion point to the left."
    },
    {   "key": "Justify Right",
        "cmd": "justifyRight",
        "icon": "align-right",
        "desc": "Right-justifies the selection or the insertion point."
    },
    {   "key": "Outdent",
        "cmd": "outdent",
        "icon": "outdent",
        "desc": "Outdents the line containing the selection or insertion point."
    },
    {   "key": "Paste",
        "cmd": "paste",
        "icon": "clipboard",
        "desc": "Pastes the clipboard contents at the insertion point (replaces current selection). Clipboard capability must be enabled in the user.js preference file. See"
    },
    {   "key": "Redo",
        "cmd": "redo",
        "icon": "repeat",
        "desc": "Redoes the previous undo command."
    },
    {   "key": "Remove Format",
        "cmd": "removeFormat",
        "desc": "Removes all formatting from the current selection."
    },
    {   "key": "Select All",
        "cmd": "selectAll",
        "desc": "Selects all of the content of the editable region."
    },
    {   "key": "Strikethrough",
        "cmd": "strikeThrough",
        "icon": "strikethrough",
        "desc": "Toggles strikethrough on/off for the selection or at the insertion point."
    },
    {   "key": "Subscript",
        "cmd": "subscript",
        "icon": "subscript",
        "desc": "Toggles subscript on/off for the selection or at the insertion point."
    },
    {   "key": "Superscript",
        "cmd": "superscript",
        "icon": "superscript",
        "desc": "Toggles superscript on/off for the selection or at the insertion point."
    },
    {   "key": "Underline",
        "cmd": "underline",
        "icon": "underline",
        "desc": "Toggles underline on/off for the selection or at the insertion point."
    },
    {   "key": "Undo",
        "cmd": "undo",
        "icon": "undo",
        "desc": "Undoes the last executed command."
    },
    {   "key": "Unlink",
        "cmd": "unlink",
        "icon": "chain-broken",
        "desc": "Removes the anchor tag from a selected anchor link."
    },
    {   "key": "Use CSS",
        "cmd": "useCSS",
        "desc": "Toggles the use of HTML tags or CSS for the generated markup. Requires a boolean true/false as a value argument. NOTE: This argument is logically backwards (i.e. use false to use CSS, true to use HTML) and unsupported by Internet Explorer. This has been deprecated in favor of styleWithCSS."
    },
    {   "key": "Style With CSS",
        "cmd": "styleWithCSS",
        "desc": "Replaces the useCSS command; argument works as expected, i.e. true modifies/generates style attributes in markup, false generates formatting elements."
    }
];

var commands = {};
var menuItems = {}
function commandsInit() {
    commandsArray.map(function(command, i) {
        commands[command.key] = command.cmd;
    });
    
    commandsArray.map(function(command, i) {
        menuItems[command.cmd] = command.key;
    });
}

function doCommand(key, val) {
    if (typeof val == "undefined") {
        val = ""
    }
    document.execCommand(commands[key], false, val)
}

commandsInit();


/*
window.webkit.messageHandlers.callback_text.postMessage("Here");

var commandsStyle =  ["Bold", "Italic", "Strikethrough", "Subscript", "Superscript", "Underline", "Remove Format"]
var commandsLink =  ["Create Link", "Edit Link", "Unlink"]
var commandsCutCopyPasteDelete = ["Cut", "Copy", "Paste", "Delete", "Forward Delete"]
var commandsUndoRedo =  ["Undo", "Redo"]
var commandsSelectAllFormat =  ["Select All"]
var commandsIndent = ["Indent", "Outdent"]
var commandsJustification = ["Justify Left", "Justify Right", "Justify Center", "Justify Full"]
var commandsInsert = ["Insert Br On Return", "Insert Horizontal Rule", "Insert HTML", "Insert Image", "Insert Ordered List", "Insert Unordered List", "Insert Paragraph", "Insert Text"]
var commandsCSS = ["Style With CSS"]
var commandsFont = ["Font Name", "Font Size", "Fore Color", "Background Color", "Hilite Color", "Increase Font Size", "Decrease Font Size"]
var commandsEnable = ["Enable Absolute Position Editor", "Enable Inline Table Editing", "Enable Object Resizing"]
var commandsBlockFormat = ["Format Block", "Heading"]
var commandsMiscellaneous = ["Set Content Read Only", "Default Paragraph Separator"]
*/
