
// let tooltip;

function startMutationObserver() {
  // target node to be observed
  var target = document.querySelector('body');
  // mutation observer config object with the listeners configuration
  var config = listenOnlyAttributeChanges();
  // mutation observer instantiation
  var mutationObs = new MutationObserver(callbackAttributeChange);
  // observe initialization
  mutationObs.observe(target, config);
}

function listenOnlyAttributeChanges() {
  return {
    attributes: true,
    characterData: true,
    childList: true,
    subtree: true
  };
}

function listenAllMutationChanges() {
  return {
    attributes: true,
    characterData: true,
    childList: true,
    subtree: true,
    attributeOldValue: true,
    characterDataOldValue: true
  };
}

function callbackAttributeChange(mutations, mutationObs) {
  //for (var i = 0, length = mutations.length; i < length; i++) {
    var mutation = mutations[mutations.length-1];
    mutationObs.takeRecords()
    //console.log('callbackAttributeChange')
    window.webkit.messageHandlers.mutationObserver.postMessage('callbackAttributeChange');
  //}
}

document.onmouseover = function(event) {
    let mousedOverElem = event.target.closest('a, img');
    if (!mousedOverElem) {
        window.webkit.messageHandlers.mouseEvent_text.postMessage('');
        return;
    }
    
    console.log(mousedOverElem.tagName)
    if (mousedOverElem.tagName.toLowerCase() == 'a') {
        window.webkit.messageHandlers.mouseEvent_text.postMessage(mousedOverElem.getAttribute('href'));
        //tooltip = showTooltip(mousedOverElem, mousedOverElem.getAttribute('href'));
    }
    else if (mousedOverElem.tagName.toLowerCase() == 'img') {
        window.webkit.messageHandlers.mouseEvent_text.postMessage(mousedOverElem.getAttribute('src'));
        //tooltip = showTooltip(mousedOverElem, mousedOverElem.getAttribute('src'));
    }
    else {
        window.webkit.messageHandlers.mouseEvent_text.postMessage('');
    }
}

document.addEventListener("click", (event) => {
    let activeElem = event.target.closest('img, a, p, h1, h2, h3, h4, h5, h6, b, i, div, span, article, section, li, ul, nav');
    activeElem.focus()
    let cssSelector = getCssSelector(activeElem)
    //console.log(cssSelector)
    window.webkit.messageHandlers.activeElementHTML.postMessage(cssSelector);
});

var getCssSelector = (el) => {
  let path = [], parent;
  
  while (parent = el.parentNode) {
    let tag = el.tagName.toLowerCase(), siblings;
    var selectorComponent = ''
    
    if (( el.id ) || ( el.className )) {
        var elArrayString = ''
        
        if ( el.id )  {
            var elArray = el.id.split(' ')
            elArray.unshift(tag)
            elArrayString = elArray.join('#').toLowerCase()
        }
        else if ( el.className ) {
            var elArray = el.className.split(' ')
            elArray.unshift(tag)
            elArrayString = elArray.join('.').toLowerCase()
        }

        let checker = (arr, target) => target.every(v => arr.includes(v));
        let siblingArray = (sibling) => {
            var siblingArray = sibling.className.split(' ');
            siblingArray.unshift(sibling.tagName.toLowerCase());
            return siblingArray;
        }

        selectorComponent = (
              siblings = parent.children,
              [].filter.call(siblings, sibling => checker(siblingArray(sibling), elArray)).length === 1 ? elArrayString :
              `${elArrayString}:nth-child(${1+[].indexOf.call(siblings, el)})`
        )
    }
    else {
        selectorComponent = (
        siblings = parent.children,
        [].filter.call(siblings, sibling => sibling.tagName.toLowerCase() === tag).length === 1 ? tag :
        `${tag}:nth-child(${1+[].indexOf.call(siblings, el)})`
      )
    }
    
    path.unshift( selectorComponent )
    el = parent;
  };
  
  return `${path.join(' > ')}`.toLowerCase();
};

var droppedPath = ""
// the droppedPath value of the image file, to be filled in by Swift when image is dragged over the webview
document.body.addEventListener('drop', handleDrop, false)

function handleDrop(e) {
    event.preventDefault()
    event.stopPropagation()
    
    var sel = window.getSelection();
    sel.removeAllRanges();
    range = document.caretRangeFromPoint(event.clientX, event.clientY);
    sel.addRange(range);
    
    doCommand('Insert Image', droppedPath)
    // by this time, Swift would have filled in the droppedPath value
}

function selectText(el) {
    el.focus()
    el.scrollIntoView();
    var sel = window.getSelection();
    var range = document.createRange();
    range.selectNodeContents(el);
    //range.collapse(false);
    sel.removeAllRanges();
    sel.addRange(range);
}

function getSelectionParentElement() {
    var parentEl = null, sel;
    if (window.getSelection) {
        sel = window.getSelection();
        if (sel.rangeCount) {
            parentEl = sel.getRangeAt(0).commonAncestorContainer;
            if (parentEl.nodeType != 1) {
                parentEl = parentEl.parentNode;
            }
        }
    } else if ( (sel = document.selection) && sel.type != "Control") {
        parentEl = sel.createRange().parentElement();
    }
    return parentEl;
}

function replaceSelectionWithNode(node) {
    var range, html;
    if (window.getSelection && window.getSelection().getRangeAt) {
        range = window.getSelection().getRangeAt(0);
        range.deleteContents();
        range.insertNode(node);
    } else if (document.selection && document.selection.createRange) {
        range = document.selection.createRange();
        html = (node.nodeType == 3) ? node.data : node.outerHTML;
        range.pasteHTML(html);
    }
}

function isLink() {
    var parent = getSelectionParentElement();
    if (parent.tagName.toLowerCase() == 'a') {
        return true
    }
    else {
        return false
    }
}

function makeLink(urlString) {
    var selectedTextString = window.getSelection().toString().trim();
    var anchor = document.createElement("a");
    anchor.setAttribute('href', urlString);
    anchor.appendChild(document.createTextNode(selectedTextString));
    replaceSelectionWithNode(anchor);
}

function editLink(urlString) {
    var parent = getSelectionParentElement()
    if (parent.tagName.toLowerCase() == 'a' ) {
        parent.setAttribute('href', urlString)
    }
}

function getLink() {
    var parent = getSelectionParentElement()
    if (parent.tagName.toLowerCase() == 'a' ) {
        return parent.getAttribute('href')
    }
}

function removeLink() {
    var parent = getSelectionParentElement()
    if (parent.tagName.toLowerCase() == 'a' ) {
        var grandparent= parent.parentNode;
        while( parent.firstChild ) {
                grandparent.insertBefore( parent.firstChild, parent);
        }
         grandparent.removeChild(parent);
    }
}

function findAllDotClassNamesFromCSS() {
    var allRules = [];
    doFind("Class", allRules);
    
    return allRules;
}

function findAllIDNamesFromCSS() {
    var allRules = [];
    doFind("ID", allRules);
    
    return allRules;
}

function doFind(type, allRules) {
    // type = "Class", or "ID"
    var styleSheets = document.styleSheets
    
    for (var i = 0; i < styleSheets.length; i++) {
        var href = document.styleSheets[i].href;
        if ( href != null && href.startsWith('http') == true ) {
            continue;
        }

        var cssRules = styleSheets[i].cssRules;
        var subRules = []
        
        for (var j = 0; j < cssRules.length; j++) {
            getSubRules(type, cssRules[j], subRules)
        }
        
        var dict = {
            name: href,
            value: subRules
        }
        allRules.push(dict)
    }
}

function getSubRules(type, cssRule, subRules) {
    var selectorText = cssRule.selectorText
    var conditionText = cssRule.conditionText
    
    if ((selectorText) && (selectorText != '.tooltip')) {
        var selectorGroupArray =  selectorText.split(",")
         
        for (var k = 0; k < selectorGroupArray.length; k++) {
            var selectorGroup = (selectorGroupArray[k]).trim().split(" ")

            for (var m = 0; m < selectorGroup.length; m++) {
                var selector = selectorGroup[m].trim()
                
                var selectorName = getSelectorName(type, selector)
                if ( (selectorName != "") && (!subRules.includes(selectorName)) )
                    subRules.push(selectorName)
            }
        }
    }
    else if (conditionText) {
        var conditionRules = []
        var cssRules = cssRule.cssRules
        
        for (var j = 0; j < cssRules.length; j++) {
            getSubRules(type, cssRules[j], conditionRules)
        }
        
        var dict = {
            name: conditionText,
            value: conditionRules
        }
        
        subRules.push(dict)
    }
}

function getSelectorName(type, selector) {
    var name = "";
    
    if (type == "Class") {
        var indexOfDotInSelector = selector.indexOf(".");
        
        if (indexOfDotInSelector != -1) {
            name = selector.substring(indexOfDotInSelector);
            var indexOfColonInSelector = selector.indexOf(":")
            if (indexOfColonInSelector != -1) {
                name = name.substring(0, indexOfColonInSelector)
            }
            name = name.substring(1);
        }
    }
    else {
        if ((selector) && (selector.charAt(0) == '#')) {
            name = selector.substring(1);
        }
    }
    
    return name
}

function applyStyle(style) {
    var parent = getSelectionParentElement().closest('div[class]')
    parent.setAttribute('class', style)
}

function removeStyle(style) {
    var parent = getSelectionParentElement().closest('div[class]')
    parent.removeAttribute('class')
}


function capitalizeFirstLetterOfString(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}

function getCurrentJustification() {
    var parent = getSelectionParentElement().closest('*[style^="text-align:"]')
    var justification = ''
    if (parent) {
        var justSStyle = parent.getAttribute('style')
        var startPos = justSStyle.indexOf(":") + 2
        var endPos = justSStyle.indexOf(";")
        justification = 'Justify ' + capitalizeFirstLetterOfString(justSStyle.slice(startPos, endPos))
    }
    return justification
}

function removeJustfication() {
    var parent = getSelectionParentElement().closest('*[style^="text-align:"]')
    if (parent) {
        parent.style.removeProperty('text-align');
        if (parent.getAttribute('style') == '') {
            parent.removeAttribute('style')
        }
    }
}

function getTextTags() {
    var tagNames = ["b", "i", "strike", "sub", "sup", "u"];
    var parent = getSelectionParentElement()
    var includedTagNames = []
    
    if (getComputedStyle(parent).fontWeight == 'bold') {
        includedTagNames.push("b")
        tagNames.splice(0, 1)
    }
    
    while (tagNames.includes(parent.tagName.toLowerCase())) {
        includedTagNames.push(parent.tagName.toLowerCase())
        parent = parent.parentNode
    }
    
    return includedTagNames
}

function addTextTag(tagName) {
    var selectedTextString = window.getSelection().toString();
    if (selectedTextString != '') {
        var formatNode = document.createElement(tagName.toLowerCase());
        formatNode.appendChild(document.createTextNode(selectedTextString));
        replaceSelectionWithNode(formatNode);
    }
}

function removeTextTag(tagName) {
    var parent = getSelectionParentElement().closest(tagName.toLowerCase())
    if (parent.tagName.toLowerCase() == tagName.toLowerCase()) {
        var grandparent= parent.parentNode;
        while( parent.firstChild ) {
            grandparent.insertBefore( parent.firstChild, parent);
        }
        grandparent.removeChild(parent);
    }
}

document.body.setAttribute('contenteditable', 'true')
startMutationObserver();

/*
 document.body.addEventListener("drop", (event) => {
     event.preventDefault()
     event.stopPropagation()
     let dt = event.dataTransfer
     console.log(dt)
     
     var sel = window.getSelection();
     range = document.caretRangeFromPoint(event.clientX, event.clientY);
     sel.removeAllRanges();
     sel.addRange(range);
     
     let files = dt.files
     console.log(files)
     Array.from(files).forEach(file => console.log(file))
     Array.from(files).forEach(file => doCommand('Insert Image', file.name))
 });

 
document.body.addEventListener('drop', handleDrop, false)

function handleDrop(e) {
 let dt = e.dataTransfer
 let files = dt.files
 files.forEach(previewFile)
}

function previewFile(file) {
 let reader = new FileReader()
 reader.readAsDataURL(file)
 reader.onloadend = function() {
   doCommand('Insert Image', reader.result)
 }
}
 
document.onmouseout = function() {
    window.webkit.messageHandlers.mouseEvent_text.postMessage('');
    if (tooltip) {
        tooltip.remove();
        tooltip = false;
    }
}

function showTooltip(anchorElem, html) {
    let tooltipElem = document.createElement('div');
    tooltipElem.className = 'tooltip';
    tooltipElem.innerHTML = html;
    document.body.append(tooltipElem);
    
    let coords = anchorElem.getBoundingClientRect();
    
    // position the tooltip over the center of the element
    let left = coords.left + (anchorElem.offsetWidth - tooltipElem.offsetWidth) / 2;
    if (left < 0) left = 0;
    
    let top = coords.top - tooltipElem.offsetHeight - 5;
    if (top < 0) {
        top = coords.top + anchorElem.offsetHeight + 5;
    }
    
    tooltipElem.style.left = left + 'px';
    tooltipElem.style.top = top + 'px';
    
    return tooltipElem;
}
 
function removeToolTip() {
    if (tooltip) {
         tooltip.remove();
         tooltip = false;
    }
}

document.addEventListener("click", (event) => {
    if(event.metaKey) {
        //window.webkit.messageHandlers.callback_text.postMessage("command key pressed");
        var parent = getSelectionParentElement();
        if (parent.hasAttribute('contenteditable')) {
            parent.removeAttribute('contenteditable');
            parent.blur();
            document.body.focus();
        } else {
            parent.setAttribute('contenteditable', 'true');
            //document.execCommand("defaultParagraphSeparator", false, "p");
        }
    }
});
 
function addContentEditableStyleToDocument() {
     removeContentEditableStyleFromDocument()
     var styleTag = document.createElement("style")
     styleTag.textContent = '[contenteditable] { outline-color: -webkit-focus-ring-color; outline-style: auto; outline-width: 1px; }'
     // styleTag.textContent = '[contenteditable] { outline-color: -webkit-focus-ring-color; outline-style: auto; outline-width: 3px; } \n.tooltip { position: fixed; z-index: 100; padding: 8px 12px; border: 1px solid #b3c9ce; border-radius: 4px; text-align: center; font: 12px/1.3 arial, sans-serif; color: #333; background: #fff; box-shadow: 1px 1px 1px rgba(0, 0, 0, .3); }';
     document.head.appendChild(styleTag);
}

function removeContentEditableStyleFromDocument() {
     var styleList = document.head.querySelectorAll('style')
     for (var i=0; i<styleList.length; i++) {
         if (styleList[i].textContent.includes('[contenteditable]')) {
             document.head.removeChild(styleList[i])
         }
     }
}
 
function clearAllContentEditableAreas() {
 var elementList = document.querySelectorAll('[contenteditable]')
 for (var i=0; i<elementList.length; i++) {
     elementList[i].removeAttribute("contenteditable");
     elementList[i].blur();
 }
 document.body.focus();
}

function processFormForHeadTags(name) {
 var value = document.forms["FormForHeadTags"][name].value
 window.webkit.messageHandlers.callback_text.postMessage(name + "=" + value);
}

function getDocumentSource() {
 document.body.removeAttribute('contenteditable')
 var documentSource = document.documentElement.outerHTML.toString()
 document.body.setAttribute('contenteditable', 'true')
 
 return documentSource
}
 
function isEditableText() {
 var selectedTextString = window.getSelection().toString();
 return (isEditable() && (selectedTextString != ''))
}
 
function isEditable() {
 var active = document.activeElement;
 return (active.hasAttribute('contenteditable'))
}
 
function getCSSClass() {
 var parent = getSelectionParentElement().closest('DIV[class]')
 //var active = getSelectionParentElement();
 if (parent && parent.hasAttribute('class')) {
     console.log(parent)
     return parent.getAttribute('class')
 }
 else {
     return ''
 }
}

*/
